/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import sun.font.CCharToGlyphMapper;
import sun.font.CCompositeGlyphMapper;
import sun.font.CStrike;
import sun.font.CharToGlyphMapper;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.FontSubstitution;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;

public final class CFont
extends PhysicalFont
implements FontSubstitution {
    private boolean isFakeItalic;
    private String nativeFontName;
    private long nativeFontPtr;
    private int fontWidth = -1;
    private int fontWeight = -1;
    private CompositeFont compFont;
    private static FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);

    @Override
    StrikeMetrics getFontMetrics(long l) {
        throw new InternalError("Not implemented");
    }

    @Override
    float getGlyphAdvance(long l, int n) {
        throw new InternalError("Not implemented");
    }

    @Override
    void getGlyphMetrics(long l, int n, Point2D.Float float_) {
        throw new InternalError("Not implemented");
    }

    @Override
    long getGlyphImage(long l, int n) {
        throw new InternalError("Not implemented");
    }

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(long l, int n) {
        throw new InternalError("Not implemented");
    }

    @Override
    GeneralPath getGlyphOutline(long l, int n, float f, float f2) {
        throw new InternalError("Not implemented");
    }

    @Override
    GeneralPath getGlyphVectorOutline(long l, int[] nArray, int n, float f, float f2) {
        throw new InternalError("Not implemented");
    }

    @Override
    protected long getLayoutTableCache() {
        return this.getLayoutTableCacheNative(this.getNativeFontPtr());
    }

    @Override
    protected byte[] getTableBytes(int n) {
        return this.getTableBytesNative(this.getNativeFontPtr(), n);
    }

    private synchronized native long getLayoutTableCacheNative(long var1);

    private native byte[] getTableBytesNative(long var1, int var3);

    private static native long createNativeFont(String var0, int var1);

    private static native void disposeNativeFont(long var0);

    private native float getWidthNative(long var1);

    private native float getWeightNative(long var1);

    @Override
    public int getWidth() {
        if (this.fontWidth == -1) {
            float f = this.getWidthNative(this.getNativeFontPtr());
            if ((double)f == 0.0) {
                this.fontWidth = 5;
                return this.fontWidth;
            }
            f = (float)((double)f + 1.0);
            this.fontWidth = (double)(f = (float)((double)f * 100.0)) <= 50.0 ? 1 : ((double)f <= 62.5 ? 2 : ((double)f <= 75.0 ? 3 : ((double)f <= 87.5 ? 4 : ((double)f <= 100.0 ? 5 : ((double)f <= 112.5 ? 6 : ((double)f <= 125.0 ? 7 : ((double)f <= 150.0 ? 8 : 9)))))));
        }
        return this.fontWidth;
    }

    @Override
    public int getWeight() {
        if (this.fontWeight == -1) {
            float f = this.getWeightNative(this.getNativeFontPtr());
            if (f == 0.0f) {
                return 400;
            }
            f = (float)((double)f + 1.0);
            this.fontWeight = (int)(f *= 500.0f);
        }
        return this.fontWeight;
    }

    public CFont(String string) {
        this(string, string);
    }

    public CFont(String string, String string2) {
        this.handle = new Font2DHandle(this);
        this.fullName = string;
        this.familyName = string2;
        this.nativeFontName = this.fullName;
        this.setStyle();
    }

    public CFont(CFont cFont, String string) {
        this.handle = new Font2DHandle(this);
        this.fullName = string;
        this.familyName = string;
        this.nativeFontName = cFont.nativeFontName;
        this.style = cFont.style;
        this.isFakeItalic = cFont.isFakeItalic;
    }

    public CFont createItalicVariant() {
        CFont cFont = new CFont(this, this.familyName);
        cFont.nativeFontName = this.fullName;
        cFont.fullName = this.fullName + (this.style == 1 ? "" : "-") + "Italic-Derived";
        cFont.style |= 2;
        cFont.isFakeItalic = true;
        return cFont;
    }

    protected synchronized long getNativeFontPtr() {
        if (this.nativeFontPtr == 0L) {
            this.nativeFontPtr = CFont.createNativeFont(this.nativeFontName, this.style);
        }
        return this.nativeFontPtr;
    }

    static native void getCascadeList(long var0, ArrayList<String> var2);

    private CompositeFont createCompositeFont() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        CFont.getCascadeList(this.nativeFontPtr, arrayList);
        arrayList.add("Lucida Sans Regular");
        FontManager fontManager = FontManagerFactory.getInstance();
        int n = 1 + arrayList.size();
        PhysicalFont[] physicalFontArray = new PhysicalFont[n];
        physicalFontArray[0] = (PhysicalFont)fontManager.findFont2D(this.nativeFontName, 0, 0);
        int n2 = 1;
        for (String string : arrayList) {
            Font2D font2D;
            if (string.equals(".AppleSymbolsFB")) {
                string = "AppleSymbols";
            }
            if ((font2D = fontManager.findFont2D(string, 0, 0)) == null || font2D == this) continue;
            physicalFontArray[n2++] = (PhysicalFont)font2D;
        }
        if (n2 < physicalFontArray.length) {
            object = physicalFontArray;
            physicalFontArray = new PhysicalFont[n2];
            System.arraycopy(object, 0, physicalFontArray, 0, n2);
        }
        object = new CompositeFont(physicalFontArray);
        object.mapper = new CCompositeGlyphMapper((CompositeFont)object);
        return object;
    }

    @Override
    public CompositeFont getCompositeFont2D() {
        if (this.compFont == null) {
            this.compFont = this.createCompositeFont();
        }
        return this.compFont;
    }

    protected synchronized void finalize() {
        if (this.nativeFontPtr != 0L) {
            CFont.disposeNativeFont(this.nativeFontPtr);
        }
        this.nativeFontPtr = 0L;
    }

    @Override
    protected CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new CCharToGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    protected FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        if (this.isFakeItalic) {
            fontStrikeDesc = new FontStrikeDesc(fontStrikeDesc);
            fontStrikeDesc.glyphTx.concatenate(AffineTransform.getShearInstance(-0.2, 0.0));
        }
        return new CStrike(this, fontStrikeDesc);
    }

    @Override
    public FontStrike getStrike(Font font) {
        return this.getStrike(font, DEFAULT_FRC);
    }

    public String toString() {
        return "CFont { fullName: " + this.fullName + ",  familyName: " + this.familyName + ", style: " + this.style + " } aka: " + super.toString();
    }
}

