/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.UIManager;

public class install {
    static boolean gui = false;
    static boolean unixlinux;
    static boolean windows;
    static boolean sunos;
    static boolean linux;
    static boolean macos;
    static boolean headless;
    static String osname;
    static double capsfontkoef;
    static String appname;
    static String defaultdir;

    static {
        macos = false;
        capsfontkoef = 1.0;
        appname = "CloudViewClient";
        defaultdir = "cloudviewclient";
    }

    public static void main(String[] args) {
        String mess;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        headless = ge.isHeadlessInstance();
        if (!headless && args.length >= 1 && args[0].equalsIgnoreCase("gui")) {
            gui = true;
        }
        if ((osname = System.getProperty("os.name")).indexOf("Windows") == -1) {
            unixlinux = true;
            windows = false;
            if (osname.indexOf("Mac") != -1) {
                macos = true;
                if (!headless) {
                    gui = true;
                }
            }
            if (osname.indexOf("Linux") != -1) {
                linux = true;
                sunos = false;
            }
            if (osname.indexOf("SunOS") != -1) {
                sunos = true;
                linux = false;
            }
        } else {
            unixlinux = false;
            windows = true;
            sunos = false;
            linux = false;
        }
        String homedir = System.getProperty("user.home");
        JWindow spl = null;
        ImageIcon icon = null;
        JDialog topdialog = null;
        if (gui) {
            install.AdjustFonts();
            spl = install.showSplash("Wait, analyzing computer...");
        }
        byte[] b = new byte[1000];
        try {
            String contents;
            String scriptpath;
            String instdir = windows ? "c:\\" + defaultdir : String.valueOf(homedir) + File.separator + defaultdir;
            if (gui) {
                if (spl != null) {
                    spl.setVisible(false);
                    spl.dispose();
                    spl = null;
                }
                icon = new ImageIcon("sysv.gif");
                topdialog = new JDialog();
                topdialog.setAlwaysOnTop(true);
                instdir = (String)JOptionPane.showInputDialog(topdialog, "Installing " + appname + "\nEnter root directory (or 'cancel'):", "Install", 1, icon, null, instdir);
                if (instdir == null) {
                    System.exit(0);
                }
                spl = install.showSplash("Wait, installing...");
            } else {
                System.out.println("Enter destination folder ('Enter'-key for default [" + instdir + "]):");
                int read = System.in.read(b);
                String answer = new String(b, 0, read).trim().toLowerCase().replace(' ', '_');
                if (answer.length() != 0) {
                    instdir = answer;
                }
                System.out.println("The destination folder will be=[" + instdir + "]");
            }
            File fdir = new File(instdir);
            if (!fdir.exists()) {
                fdir.mkdirs();
            } else {
                System.out.println("The install directory exists, the software will be updated");
            }
            System.out.println("Extracting guiclient.tar...");
            String datatarpath = String.valueOf(instdir) + File.separator + "guiclient.tar";
            String tarexepath = String.valueOf(instdir) + File.separator + "tar.exe";
            install.extractFile("guiclient.tar", datatarpath);
            if (windows) {
                install.extractFile("tar.exe", tarexepath);
            }
            if (windows) {
                install.runApp(tarexepath, "-xvf " + datatarpath + " -C " + instdir);
            } else {
                install.runApp("tar", "-xvf " + datatarpath + " -C " + instdir);
            }
            System.out.println("done extracting directory structure from guiclient.tar");
            install.DeleteFile(datatarpath);
            if (windows) {
                install.DeleteFile(String.valueOf(instdir) + "\\startguiclient.sh");
                scriptpath = String.valueOf(instdir) + "\\startguiclient.bat";
                contents = "java -cp " + instdir + "\\lib\\devwin.jar;" + instdir + "\\lib\\jnlp.jar" + " devwin";
                install.writeLinuxScript(scriptpath, contents);
                install.DeleteFile(String.valueOf(instdir) + "\\uninstall.sh");
                scriptpath = String.valueOf(instdir) + "\\uninstall.bat";
                contents = "rm -rf " + instdir + "\n";
                install.writeLinuxScript(scriptpath, contents);
            } else {
                install.DeleteFile(String.valueOf(instdir) + "/startguiclient.bat");
                scriptpath = String.valueOf(instdir) + "/startguiclient.sh";
                contents = "java -cp " + instdir + "/lib/devwin.jar:" + instdir + "/lib/jnlp.jar" + " devwin";
                if (macos) {
                    contents = String.valueOf(instdir) + "/java/bin/" + contents;
                }
                install.writeLinuxScript(scriptpath, contents);
                install.DeleteFile(String.valueOf(instdir) + "/uninstall.bat");
                scriptpath = String.valueOf(instdir) + "/uninstall.sh";
                contents = "#!/bin/sh\nrm -rf " + instdir + "\n";
                install.writeLinuxScript(scriptpath, contents);
            }
            System.out.println("*** Successfully installed software ***");
            if (windows) {
                System.out.println(" 1. To start client     [" + instdir + "\\startguiclient.bat]");
                System.out.println(" 2. To uninstall client [" + instdir + "\\uninstall.bat]");
            } else {
                System.out.println(" 1. To start client     [sudo " + instdir + "/startguiclient.sh]");
                System.out.println(" 2. To uninstall client [sudo " + instdir + "/uninstall.sh]");
            }
            if (gui && macos) {
                if (spl != null) {
                    spl.setVisible(false);
                    spl.dispose();
                    spl = null;
                }
                spl = install.showSplash("Wait, copying system files...");
                File sourceFolder = new File("java");
                File destinationFolder = new File(String.valueOf(instdir) + "/java");
                install.copyFolder(sourceFolder, destinationFolder);
                sourceFolder = new File(String.valueOf(instdir) + "/" + appname);
                destinationFolder = new File("/Applications/" + appname);
                install.copyFolder(sourceFolder, destinationFolder);
                install.DeleteRecursive(sourceFolder);
                scriptpath = "/Applications/" + appname + "/Start " + appname + ".app/Contents/MacOS/start.sh";
                contents = "#!/bin/sh\n" + instdir + "/startguiclient.sh";
                install.writeLinuxScript(scriptpath, contents);
                scriptpath = "/Applications/" + appname + "/Uninstall " + appname + ".app/Contents/MacOS/start.sh";
                contents = "#!/bin/sh\n" + instdir + "/uninstall.sh";
                install.writeLinuxScript(scriptpath, contents);
                scriptpath = String.valueOf(instdir) + "/uninstall.sh";
                contents = "#!/bin/sh\nrm -rf " + instdir + "\n" + "rm -rf /Applications/" + appname + "\n" + "/usr/bin/osascript <<-EOF\n" + "tell application \"System Events\"\n" + "activate\n" + "display dialog \"Uninstall completed!\"\n" + "end tell\n" + "EOF\n";
                install.writeLinuxScript(scriptpath, contents);
            } else {
                File sourceFolder = new File(String.valueOf(instdir) + "/" + appname);
                install.DeleteRecursive(sourceFolder);
            }
        }
        catch (Exception eer) {
            mess = "Error=" + eer.getMessage();
            System.out.println(mess);
            if (gui) {
                if (spl != null) {
                    spl.setVisible(false);
                    spl.dispose();
                    spl = null;
                }
                JOptionPane.showMessageDialog(topdialog, mess, "Error!", 0, icon);
            }
            System.exit(0);
        }
        if (gui) {
            if (spl != null) {
                spl.setVisible(false);
                spl.dispose();
                spl = null;
            }
            mess = "Installation completed successfully";
            JOptionPane.showMessageDialog(topdialog, mess, "Success!", 1, icon);
        }
        System.exit(0);
    }

    static boolean DeleteRecursive(File fileOrDirectory) {
        try {
            boolean res;
            if (fileOrDirectory.isDirectory()) {
                File[] children = fileOrDirectory.listFiles();
                int i = 0;
                while (i < children.length) {
                    File child = children[i];
                    res = install.DeleteRecursive(child);
                    if (!res) {
                        return res;
                    }
                    ++i;
                }
            }
            res = fileOrDirectory.delete();
            return res;
        }
        catch (Exception ee) {
            return false;
        }
    }

    static void DeleteFile(String filepath) {
        File df = new File(filepath);
        try {
            df.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean CopyFile(String sourceName, String copyName, boolean failifexist) {
        FileOutputStream copy;
        FileInputStream source = null;
        try {
            source = new FileInputStream(sourceName);
        }
        catch (FileNotFoundException e) {
            System.out.println("Error: Can't find file \"" + sourceName + "\".");
            return false;
        }
        File file = new File(copyName);
        if (file.exists() && failifexist) {
            System.out.println("Error: Output file exists");
            return false;
        }
        try {
            copy = new FileOutputStream(copyName);
        }
        catch (IOException e) {
            System.out.println("Error: Can't open output file \"" + copyName + "\".");
            return false;
        }
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)source).read(buf)) > 0) {
                ((OutputStream)copy).write(buf, 0, len);
            }
            ((InputStream)source).close();
            ((OutputStream)copy).close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static void writeLinuxScript(String scriptpath, String contents) throws IOException, InterruptedException {
        PrintStream out = new PrintStream(new FileOutputStream(scriptpath));
        out.println(contents);
        out.close();
        if (!windows) {
            File fl = new File(scriptpath);
            fl.setExecutable(true);
        }
    }

    private static void extractFile(String name, String outfilepath) throws IOException {
        int len;
        File target = new File(outfilepath);
        if (target.exists()) {
            return;
        }
        FileOutputStream out = new FileOutputStream(target);
        ClassLoader cl = install.class.getClassLoader();
        InputStream in = cl.getResourceAsStream(name);
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        out.close();
        in.close();
    }

    static void runApp(String fullpath, String pars) {
        String torun = "not initialized";
        try {
            Runtime run = Runtime.getRuntime();
            if (windows && fullpath.indexOf("tar.exe") == -1) {
                String line;
                System.out.println("win running process=[" + fullpath + " " + pars + "]");
                String[] command = new String[4];
                command[0] = "cmd";
                command[1] = "/C";
                if (fullpath.charAt(0) == '/' && fullpath.charAt(2) == ':') {
                    fullpath = fullpath.substring(1);
                }
                command[2] = fullpath;
                command[3] = pars;
                Process pr = run.exec(command);
                BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                while ((line = buf.readLine()) != null) {
                }
                pr.waitFor();
            } else {
                String line;
                torun = String.valueOf(fullpath) + " " + pars;
                System.out.println("lin running process=[" + torun + "]");
                Process pr = run.exec(torun);
                BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                while ((line = buf.readLine()) != null) {
                }
                pr.waitFor();
            }
        }
        catch (Exception e) {
            System.out.println("Exception running [" + torun + "]" + e.getMessage());
        }
    }

    static void copyFolder(File sourceFolder, File destinationFolder) throws IOException {
        if (sourceFolder.isDirectory()) {
            String[] files;
            if (!destinationFolder.exists()) {
                destinationFolder.mkdir();
                System.out.println("Directory created :: " + destinationFolder);
            }
            String[] stringArray = files = sourceFolder.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(sourceFolder, file);
                File destFile = new File(destinationFolder, file);
                install.copyFolder(srcFile, destFile);
                ++n2;
            }
        } else {
            Files.copy(sourceFolder.toPath(), destinationFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.out.println("File copied :: " + destinationFolder);
        }
    }

    static void AdjustFonts() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (windows) {
            capsfontkoef = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0;
        } else {
            capsfontkoef = (double)dim.width / 1920.0;
            if (capsfontkoef < 1.0) {
                capsfontkoef = 1.0;
            }
        }
        System.out.println("** Fonts koef=" + capsfontkoef);
        install.IncreaseGlobalFonts(capsfontkoef);
    }

    static void IncreaseGlobalFonts(double kf) {
        if (kf > 0.99 && kf < 1.01) {
            return;
        }
        Set keySet = UIManager.getLookAndFeelDefaults().keySet();
        Object[] keys = keySet.toArray(new Object[keySet.size()]);
        int i = 0;
        while (i < keys.length) {
            Font font;
            Object key = keys[i];
            if (key != null && key.toString().toLowerCase().contains("font") && (font = UIManager.getDefaults().getFont(key)) != null) {
                int newSize = (int)(kf * (double)font.getSize());
                font = font.deriveFont((float)newSize);
                UIManager.put(key, font);
            }
            ++i;
        }
    }

    public static JWindow showSplash(String text) {
        JWindow jwn = new JWindow();
        JPanel content = (JPanel)jwn.getContentPane();
        content.setBackground(Color.white);
        int width = (int)(450.0 * capsfontkoef);
        int height = (int)(115.0 * capsfontkoef);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        jwn.setBounds(x, y, width, height);
        JLabel copyrt = new JLabel(text, 0);
        copyrt.setFont(new Font("Sans-Serif", 1, (int)(12.0 * capsfontkoef)));
        content.add((Component)copyrt, "Center");
        Color oraRed = new Color(156, 20, 20, 255);
        content.setBorder(BorderFactory.createLineBorder(oraRed, 10));
        jwn.setAlwaysOnTop(true);
        jwn.setVisible(true);
        return jwn;
    }
}

